<?php if (isset($component)) { $__componentOriginaledd332298c22106486e51e8eba515b74 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaledd332298c22106486e51e8eba515b74 = $attributes; } ?>
<?php $component = App\View\Components\HrLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('hr-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\HrLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
     <?php $__env->slot('header', null, []); ?> 
        <h2 class="font-semibold text-xl text-gray-800 leading-tight">
            Manajemen Interview
        </h2>
     <?php $__env->endSlot(); ?>

    <div class="max-w-7xl mx-auto py-6 px-4 sm:px-6 lg:px-8">
        <!-- Success Message -->
        <?php if(session('success')): ?>
            <div class="mb-4 bg-green-50 border border-green-200 text-green-700 px-4 py-3 rounded relative" role="alert">
                <span class="block sm:inline"><?php echo e(session('success')); ?></span>
            </div>
        <?php endif; ?>

        <!-- Filters -->
        <div class="bg-white rounded-lg shadow-sm p-6 mb-6">
            <form method="GET" action="<?php echo e(route('hr.interviews.index')); ?>" class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <!-- Search -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Cari Kandidat</label>
                        <input type="text" name="search" value="<?php echo e(request('search')); ?>" 
                            placeholder="Nama kandidat..." 
                            class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring focus:ring-blue-200">
                    </div>

                    <!-- Status Filter -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Status</label>
                        <select name="status" class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring focus:ring-blue-200">
                            <option value="">Semua Status</option>
                            <option value="scheduled" <?php echo e(request('status') == 'scheduled' ? 'selected' : ''); ?>>Terjadwal</option>
                            <option value="completed" <?php echo e(request('status') == 'completed' ? 'selected' : ''); ?>>Selesai</option>
                            <option value="cancelled" <?php echo e(request('status') == 'cancelled' ? 'selected' : ''); ?>>Dibatalkan</option>
                            <option value="rescheduled" <?php echo e(request('status') == 'rescheduled' ? 'selected' : ''); ?>>Dijadwalkan Ulang</option>
                        </select>
                    </div>

                    <!-- Interviewer Filter -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Pewawancara</label>
                        <select name="interviewer_id" class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring focus:ring-blue-200">
                            <option value="">Semua Pewawancara</option>
                            <?php $__currentLoopData = $interviewers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interviewer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($interviewer->id); ?>" <?php echo e(request('interviewer_id') == $interviewer->id ? 'selected' : ''); ?>>
                                    <?php echo e($interviewer->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- Date From -->
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-2">Dari Tanggal</label>
                        <input type="date" name="date_from" value="<?php echo e(request('date_from')); ?>" 
                            class="w-full rounded-lg border-gray-300 focus:border-blue-500 focus:ring focus:ring-blue-200">
                    </div>
                </div>

                <div class="flex justify-end space-x-2">
                    <a href="<?php echo e(route('hr.interviews.index')); ?>" class="px-4 py-2 border border-gray-300 rounded-lg text-gray-700 hover:bg-gray-50">
                        Reset
                    </a>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700">
                        <i class="fas fa-search mr-2"></i>Filter
                    </button>
                </div>
            </form>
        </div>

        <!-- Interviews Table -->
        <div class="bg-white rounded-lg shadow-sm overflow-hidden">
            <div class="overflow-x-auto">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Kandidat
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Posisi
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Jadwal
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Pewawancara
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Tipe
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Status
                            </th>
                            <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">
                                Aksi
                            </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        <?php $__empty_1 = true; $__currentLoopData = $interviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interview): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="flex items-center">
                                        <div class="flex-shrink-0 h-10 w-10">
                                            <div class="h-10 w-10 rounded-full bg-blue-100 flex items-center justify-center">
                                                <span class="text-blue-600 font-semibold">
                                                    <?php echo e(substr($interview->application->candidate->name, 0, 2)); ?>

                                                </span>
                                            </div>
                                        </div>
                                        <div class="ml-4">
                                            <div class="text-sm font-medium text-gray-900">
                                                <?php echo e($interview->application->candidate->name); ?>

                                            </div>
                                            <div class="text-sm text-gray-500">
                                                <?php echo e($interview->application->candidate->email); ?>

                                            </div>
                                        </div>
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900"><?php echo e($interview->application->jobPosting->title); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900">
                                        <?php echo e(\Carbon\Carbon::parse($interview->scheduled_at)->format('d M Y')); ?>

                                    </div>
                                    <div class="text-sm text-gray-500">
                                        <?php echo e(\Carbon\Carbon::parse($interview->scheduled_at)->format('H:i')); ?> 
                                        (<?php echo e($interview->duration); ?> menit)
                                    </div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <div class="text-sm text-gray-900"><?php echo e($interview->interviewer->name); ?></div>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 py-1 text-xs rounded-full
                                        <?php if($interview->interview_type === 'onsite'): ?> bg-blue-100 text-blue-800
                                        <?php elseif($interview->interview_type === 'video'): ?> bg-green-100 text-green-800
                                        <?php else: ?> bg-purple-100 text-purple-800
                                        <?php endif; ?>">
                                        <?php if($interview->interview_type === 'onsite'): ?> On-site
                                        <?php elseif($interview->interview_type === 'video'): ?> Video
                                        <?php else: ?> Telepon
                                        <?php endif; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap">
                                    <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full
                                        <?php if($interview->status === 'scheduled'): ?> bg-yellow-100 text-yellow-800
                                        <?php elseif($interview->status === 'completed'): ?> bg-green-100 text-green-800
                                        <?php elseif($interview->status === 'cancelled'): ?> bg-red-100 text-red-800
                                        <?php else: ?> bg-gray-100 text-gray-800
                                        <?php endif; ?>">
                                        <?php if($interview->status === 'scheduled'): ?> Terjadwal
                                        <?php elseif($interview->status === 'completed'): ?> Selesai
                                        <?php elseif($interview->status === 'cancelled'): ?> Dibatalkan
                                        <?php else: ?> Dijadwalkan Ulang
                                        <?php endif; ?>
                                    </span>
                                </td>
                                <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                    <a href="<?php echo e(route('hr.applications.show', $interview->application_id)); ?>" 
                                        class="text-blue-600 hover:text-blue-900 mr-3">
                                        Detail
                                    </a>
                                    <?php if($interview->status === 'scheduled'): ?>
                                        <form action="<?php echo e(route('hr.interviews.destroy', $interview->id)); ?>" 
                                            method="POST" class="inline"
                                            onsubmit="return confirm('Yakin ingin membatalkan interview ini?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="text-red-600 hover:text-red-900">
                                                Batalkan
                                            </button>
                                        </form>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="7" class="px-6 py-4 text-center text-gray-500">
                                    Tidak ada data interview
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>

            <!-- Pagination -->
            <div class="bg-white px-4 py-3 border-t border-gray-200 sm:px-6">
                <?php echo e($interviews->links()); ?>

            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaledd332298c22106486e51e8eba515b74)): ?>
<?php $attributes = $__attributesOriginaledd332298c22106486e51e8eba515b74; ?>
<?php unset($__attributesOriginaledd332298c22106486e51e8eba515b74); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaledd332298c22106486e51e8eba515b74)): ?>
<?php $component = $__componentOriginaledd332298c22106486e51e8eba515b74; ?>
<?php unset($__componentOriginaledd332298c22106486e51e8eba515b74); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\easyrecruit\resources\views/hr/interviews/index.blade.php ENDPATH**/ ?>