<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Konfigurasi Sistem - Super Admin</title>
    <script src="https://cdn.tailwindcss.com"></script>
</head>
<body class="bg-gray-50">
    <?php echo $__env->make('components.superadmin-sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- Main Content -->
    <main style="margin-left: 256px;">
        <!-- Top Bar -->
        <div class="bg-white border-b px-8 py-4 flex justify-between items-center">
            <div>
                <h2 class="text-2xl font-bold text-gray-800">Konfigurasi Sistem</h2>
                <p class="text-sm text-gray-600 mt-1">Template Notifikasi & Pengaturan Sistem</p>
            </div>
            <div class="flex items-center gap-4">
                <div class="text-right">
                    <p class="text-sm font-medium text-gray-900"><?php echo e(auth()->user()->name); ?></p>
                    <p class="text-xs text-gray-500">Super Admin</p>
                </div>
                <div class="w-10 h-10 bg-blue-600 rounded-full flex items-center justify-center text-white font-semibold">
                    <?php echo e(substr(auth()->user()->name, 0, 1)); ?>

                </div>
            </div>
        </div>

        <!-- Content -->
        <div class="p-8">
            <?php if(session('success')): ?>
            <div class="mb-6 bg-green-50 border border-green-200 text-green-800 px-4 py-3 rounded-lg">
                <?php echo e(session('success')); ?>

            </div>
            <?php endif; ?>

            <?php if(session('error')): ?>
            <div class="mb-6 bg-red-50 border border-red-200 text-red-800 px-4 py-3 rounded-lg">
                <?php echo e(session('error')); ?>

            </div>
            <?php endif; ?>

            <!-- Template Notifikasi Section -->
            <div class="mb-8">
                <div class="flex justify-between items-center mb-4">
                    <div>
                        <h3 class="text-lg font-semibold">Template Notifikasi</h3>
                        <p class="text-sm text-gray-600 mt-1">Kelola template email, WhatsApp, dan SMS</p>
                    </div>
                    <button onclick="openModal()" class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-lg text-sm">
                        + Tambah Template
                    </button>
                </div>

                <!-- Available Placeholders Info -->
                <div class="bg-blue-50 border border-blue-200 rounded-lg p-4 mb-6">
                    <h4 class="font-semibold text-blue-900 mb-2">Placeholder Yang Tersedia:</h4>
                    <div class="grid grid-cols-3 gap-2 text-sm text-blue-800">
                        <div><code class="bg-white px-2 py-1 rounded">{{ nama }}</code> - Nama kandidat</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ email }}</code> - Email kandidat</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ posisi }}</code> - Posisi yang dilamar</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ kode_lamaran }}</code> - Kode lamaran</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ tanggal }}</code> - Tanggal</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ waktu }}</code> - Waktu</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ lokasi }}</code> - Lokasi interview</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ interviewer }}</code> - Nama interviewer</div>
                        <div><code class="bg-white px-2 py-1 rounded">{{ gaji }}</code> - Penawaran gaji</div>
                    </div>
                </div>

                <!-- Templates Table -->
                <div class="bg-white rounded-lg shadow-sm border">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Event</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Channel</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Subject</th>
                                <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Aksi</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-200">
                            <?php $__empty_1 = true; $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr class="hover:bg-gray-50">
                                <td class="px-6 py-4">
                                    <span class="text-sm font-medium text-gray-900"><?php echo e($template->event); ?></span>
                                </td>
                                <td class="px-6 py-4">
                                    <?php if($template->channel == 'email'): ?>
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full bg-blue-100 text-blue-800">Email</span>
                                    <?php elseif($template->channel == 'whatsapp'): ?>
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full bg-green-100 text-green-800">WhatsApp</span>
                                    <?php else: ?>
                                    <span class="px-3 py-1 text-xs font-semibold rounded-full bg-purple-100 text-purple-800">SMS</span>
                                    <?php endif; ?>
                                </td>
                                <td class="px-6 py-4 text-sm text-gray-500"><?php echo e($template->subject ?? '-'); ?></td>
                                <td class="px-6 py-4 text-sm">
                                    <button onclick='editTemplate(<?php echo json_encode($template, 15, 512) ?>)' class="text-blue-600 hover:text-blue-900 mr-3">Edit</button>
                                    <form action="<?php echo e(route('superadmin.templates.destroy', $template)); ?>" method="POST" class="inline" onsubmit="return confirm('Yakin ingin menghapus template ini?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button type="submit" class="text-red-600 hover:text-red-900">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="4" class="px-6 py-12 text-center text-gray-500">
                                    <svg class="mx-auto h-12 w-12 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"/>
                                    </svg>
                                    <p class="mt-4">Belum ada template notifikasi</p>
                                </td>
                            </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </main>

    <!-- Modal Template -->
    <div id="templateModal" class="hidden fixed inset-0 bg-gray-600 bg-opacity-50 overflow-y-auto h-full w-full z-50">
        <div class="relative top-10 mx-auto p-5 border w-3/4 max-w-3xl shadow-lg rounded-md bg-white">
            <h3 class="text-lg font-bold mb-4" id="modalTitle">Tambah Template Notifikasi</h3>
            <form id="templateForm" method="POST" action="<?php echo e(route('superadmin.templates.store')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" id="templateMethod" name="_method" value="POST">
                
                <div class="grid grid-cols-2 gap-4 mb-4">
                    <div>
                        <label class="block text-sm font-medium mb-2">Event *</label>
                        <select name="event" id="templateEvent" required class="w-full px-3 py-2 border rounded-lg">
                            <option value="">-- Pilih Event --</option>
                            <option value="application_submitted">Lamaran Diterima</option>
                            <option value="screening_passed">Lolos Screening</option>
                            <option value="screening_rejected">Tidak Lolos Screening</option>
                            <option value="interview_scheduled">Undangan Interview</option>
                            <option value="interview_reminder">Reminder Interview</option>
                            <option value="interview_passed">Lolos Interview</option>
                            <option value="interview_rejected">Tidak Lolos Interview</option>
                            <option value="offer_sent">Penawaran Kerja</option>
                            <option value="offer_accepted">Offer Diterima</option>
                            <option value="offer_rejected">Offer Ditolak</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium mb-2">Channel *</label>
                        <select name="channel" id="templateChannel" required class="w-full px-3 py-2 border rounded-lg">
                            <option value="">-- Pilih Channel --</option>
                            <option value="email">Email</option>
                            <option value="whatsapp">WhatsApp</option>
                            <option value="sms">SMS</option>
                        </select>
                    </div>
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium mb-2">Subject (untuk Email)</label>
                    <input type="text" name="subject" id="templateSubject" class="w-full px-3 py-2 border rounded-lg" placeholder="Contoh: Konfirmasi Lamaran - {{ posisi }}">
                </div>

                <div class="mb-4">
                    <label class="block text-sm font-medium mb-2">Body/Isi Pesan *</label>
                    <textarea name="body" id="templateBody" required rows="8" class="w-full px-3 py-2 border rounded-lg font-mono text-sm" placeholder="Dear {{ nama }},&#10;&#10;Terima kasih telah melamar posisi {{ posisi }} di perusahaan kami..."></textarea>
                    <p class="text-xs text-gray-500 mt-1">Gunakan placeholder seperti {{ nama }}, {{ posisi }}, dll.</p>
                </div>

                <div class="flex justify-end gap-2">
                    <button type="button" onclick="closeModal()" class="px-4 py-2 bg-gray-200 rounded-lg">Batal</button>
                    <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg">Simpan Template</button>
                </div>
            </form>
        </div>
    </div>

    <script>
        function openModal() {
            document.getElementById('templateModal').classList.remove('hidden');
        }

        function closeModal() {
            document.getElementById('templateModal').classList.add('hidden');
            document.getElementById('templateForm').reset();
            document.getElementById('templateForm').action = "<?php echo e(route('superadmin.templates.store')); ?>";
            document.getElementById('templateMethod').value = 'POST';
            document.getElementById('modalTitle').textContent = 'Tambah Template Notifikasi';
        }

        function editTemplate(template) {
            document.getElementById('templateForm').action = "<?php echo e(url('superadmin/templates')); ?>/" + template.id;
            document.getElementById('templateMethod').value = 'PUT';
            document.getElementById('templateEvent').value = template.event;
            document.getElementById('templateChannel').value = template.channel;
            document.getElementById('templateSubject').value = template.subject || '';
            document.getElementById('templateBody').value = template.body;
            document.getElementById('modalTitle').textContent = 'Edit Template Notifikasi';
            openModal();
        }
    </script>
</body>
</html>
<?php /**PATH C:\laragon\www\easyrecruit\resources\views/superadmin/config/index.blade.php ENDPATH**/ ?>